/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service.pushservices;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.push.model.v20160801.PushRequest;
import com.aliyuncs.push.model.v20160801.PushResponse;
import com.aliyuncs.utils.ParameterHelper;
import com.fshows.lifecircle.service.dao.FbAlipushConfigMapperExt;
import com.fshows.lifecircle.service.dao.FbAppMessageMapperExt;
import com.fshows.lifecircle.service.domain.FbAlipushConfig;
import com.fshows.lifecircle.service.manager.formModels.ApiPushModel;
import com.fshows.lifecircle.service.openapi.facade.domain.result.ErrorCode;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.gexin.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AliPushService {
    private static final Logger log = LoggerFactory.getLogger(AliPushService.class);
    @Autowired
    private FbAlipushConfigMapperExt tpAlipushConfigMapperExt;
    @Autowired
    private FbAppMessageMapperExt fbAppMessageMapperExt;

    public BizResponse aliPush(ApiPushModel apiPushModel) {
        Long oemId = 0L;
        String OEM_ID = "oem_id";
        Map map = (Map)JSON.parse((String)apiPushModel.getExtendContent());
        if (map != null && map.get(OEM_ID) != null && !"".equals(map.get(OEM_ID))) {
            oemId = Long.valueOf(map.get(OEM_ID).toString());
        }
        FbAlipushConfig fbAlipushConfig = this.tpAlipushConfigMapperExt.selectByOemId(oemId);
        log.info("AliPush -- >> \u963f\u91cc\u63a8\u9001\u914d\u7f6e\u83b7\u53d6\uff1a tpAlipushConfig = {}", (Object)JSON.toJSONString((Object)fbAlipushConfig));
        return this.startPush(apiPushModel, fbAlipushConfig);
    }

    public BizResponse startPush(ApiPushModel apiPushModel, FbAlipushConfig fbAlipushConfig) {
        try {
            DefaultProfile profile = DefaultProfile.getProfile((String)fbAlipushConfig.getAliyunRegionid(), (String)fbAlipushConfig.getAliyunAccesskey(), (String)fbAlipushConfig.getAliyunSecretkey());
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            PushRequest pushRequest = new PushRequest();
            Map map = (Map)JSON.parse((String)apiPushModel.getExtendContent());
            String sound = "default";
            String activity = "APPLICATION";
            if (map.get("sound") != null) {
                sound.equals(map.get("sound"));
            }
            if (map.get("activity") != null) {
                activity.equals(map.get("activity"));
            }
            pushRequest.setAppKey(Long.valueOf(Long.parseLong(fbAlipushConfig.getAliyunAppkey())));
            pushRequest.setTarget("DEVICE");
            pushRequest.setTargetValue(apiPushModel.getTargetValue());
            if (1 == apiPushModel.getPassThrough()) {
                apiPushModel.setBody(apiPushModel.getExtendContent());
                pushRequest.setPushType("MESSAGE");
            } else if (0 == apiPushModel.getPassThrough()) {
                pushRequest.setPushType("NOTICE");
            } else {
                return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)"\u672a\u77e5\u900f\u4f20\u65b9\u5f0f");
            }
            if (1 == apiPushModel.getDeviceType()) {
                pushRequest.setDeviceType("ANDROID");
            } else if (2 == apiPushModel.getDeviceType()) {
                pushRequest.setDeviceType("iOS");
            } else {
                return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)"\u672a\u77e5\u8bbe\u5907\u7c7b\u578b");
            }
            pushRequest.setTitle(apiPushModel.getTitle());
            pushRequest.setBody(apiPushModel.getBody());
            pushRequest.setIOSBadge(Integer.valueOf(1));
            pushRequest.setIOSMusic(sound);
            if (1 == apiPushModel.getNotifyType()) {
                pushRequest.setIOSSilentNotification(Boolean.valueOf(true));
            }
            pushRequest.setIOSMutableContent(Boolean.valueOf(true));
            pushRequest.setIOSApnsEnv(fbAlipushConfig.getIosApnsEnv());
            pushRequest.setIOSExtParameters(apiPushModel.getExtendContent());
            pushRequest.setAndroidNotifyType("BOTH");
            pushRequest.setAndroidNotificationBarType(Integer.valueOf(1));
            pushRequest.setAndroidNotificationBarPriority(Integer.valueOf(1));
            if (1 == apiPushModel.getActionType()) {
                pushRequest.setAndroidOpenType("APPLICATION");
            } else if (2 == apiPushModel.getActionType()) {
                pushRequest.setAndroidOpenType("URL");
            } else {
                pushRequest.setAndroidOpenType("NONE");
            }
            pushRequest.setAndroidOpenUrl(apiPushModel.getActionUrl());
            pushRequest.setAndroidActivity(activity);
            pushRequest.setAndroidMusic("default");
            pushRequest.setAndroidExtParameters(apiPushModel.getExtendContent());
            int timeOut = apiPushModel.getTimeOut();
            pushRequest.setExpireTime(ParameterHelper.getISO8601Time((Date)new Date(System.currentTimeMillis() + (long)(timeOut * 1000))));
            pushRequest.setStoreOffline(Boolean.valueOf(true));
            PushResponse pushResponse = (PushResponse)client.getAcsResponse((AcsRequest)pushRequest);
            this.fbAppMessageMapperExt.updateMessageByStatus(apiPushModel.getMessageId(), Integer.valueOf(1));
            HashMap data = Maps.newHashMap();
            data.put("RequestId", pushResponse.getRequestId());
            data.put("MessageID", pushResponse.getMessageId());
            return BizResponse.success((Object)data);
        }
        catch (Exception e) {
            return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)e.getMessage());
        }
    }
}

