/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service;

import com.fshows.lifecircle.service.openapi.facade.domain.result.ErrorCode;
import com.fshows.lifecircle.service.openapi.facade.domain.result.PVCSRusult;
import com.fshows.lifecircle.service.service.contants.CommonConstant;
import com.fshows.lifecircle.service.service.utils.RandomUtil;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.github.botaruibo.xvcode.generator.Gif2VCGenerator;
import com.github.botaruibo.xvcode.generator.PngVCGenerator;
import com.xiaoleilu.hutool.exceptions.ExceptionUtil;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Encoder;

@Service
public class PictureVCService {
    private static final Logger log = LoggerFactory.getLogger(PictureVCService.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public BizResponse<PVCSRusult> getPVSPngCode(Integer channelType, Integer height, Integer width, Integer count) {
        int randomCode = RandomUtil.buildRandom(6);
        String token = CommonConstant.PVSCODE_REDIS_KEY + randomCode + "_" + channelType;
        PngVCGenerator generator = new PngVCGenerator(width.intValue(), height.intValue(), count.intValue());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)generator.getValidCodeImage(), "jpg", baos);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("PictureVCService -- >> getPVSPngCode \u6d41\u6570\u636e\u8f6c\u5316\u9519\u8bef\uff1ae = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
        }
        String PVCodeText = generator.text();
        this.stringRedisTemplate.opsForValue().set((Object)token, (Object)PVCodeText, 300L, TimeUnit.SECONDS);
        String code = new BASE64Encoder().encode(baos.toByteArray());
        PVCSRusult rusult = new PVCSRusult();
        rusult.setCode(code);
        rusult.setToken(token);
        return BizResponse.success((Object)rusult);
    }

    public BizResponse<PVCSRusult> getPVSGifCode(Integer channelType, Integer height, Integer width, Integer count) {
        int randomCode = RandomUtil.buildRandom(6);
        String token = CommonConstant.PVSCODE_REDIS_KEY + randomCode + "_" + channelType;
        Gif2VCGenerator generator = new Gif2VCGenerator(width.intValue(), height.intValue(), count.intValue());
        String FileOutUrl = "D://gif/" + token + ".gif";
        String code = "";
        try {
            generator.write2out((OutputStream)new FileOutputStream(FileOutUrl)).close();
            FileInputStream in = new FileInputStream(FileOutUrl);
            byte[] data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
            String PVCodeText = generator.text();
            this.stringRedisTemplate.opsForValue().set((Object)token, (Object)PVCodeText, 300L, TimeUnit.SECONDS);
            code = new BASE64Encoder().encode(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("PictureVCService -- >> getPVSPngCode \u6d41\u6570\u636e\u8f6c\u5316\u9519\u8bef\uff1ae = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
        }
        PVCSRusult rusult = new PVCSRusult();
        rusult.setCode(code);
        rusult.setToken(token);
        return BizResponse.success((Object)rusult);
    }

    public BizResponse<Boolean> checkCodeForChannel(Integer channelType, String token, String code) {
        String[] sl = token.split("_");
        if (sl == null || sl.length == 0 || sl[1] == null) {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        if (!sl[1].equals(channelType.toString())) {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        String PVCodeText = (String)this.stringRedisTemplate.opsForValue().get((Object)token);
        if (StringUtils.isBlank((CharSequence)PVCodeText)) {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        if (PVCodeText.toUpperCase().equals(code.toUpperCase())) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
    }
}

