/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service;

import com.fshows.lifecircle.service.dao.FbKoubeiCategoryMapperExt;
import com.fshows.lifecircle.service.domain.models.KoubeiCategoryModel;
import com.fshows.lifecircle.service.openapi.facade.domain.result.KoubeiResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FbKoubeiCategoryService {
    private static final Logger log = LoggerFactory.getLogger(FbKoubeiCategoryService.class);
    @Autowired
    private FbKoubeiCategoryMapperExt fbKoubeiCategoryMapperExt;

    public BizResponse<List<KoubeiResult>> getParentKoubeiCategory() {
        List parentCategory = this.fbKoubeiCategoryMapperExt.getKoubeiCategory("");
        if (parentCategory == null || parentCategory.size() <= 0) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        ArrayList newParentCategory = Lists.newArrayList();
        for (KoubeiCategoryModel model : parentCategory) {
            KoubeiResult result = new KoubeiResult();
            BeanUtils.copyProperties((Object)model, (Object)result);
            newParentCategory.add(result);
        }
        return BizResponse.success((Object)newParentCategory);
    }

    public BizResponse<List<KoubeiResult>> getKoubeiCategory(String parentCategoryId) {
        List category = this.fbKoubeiCategoryMapperExt.getKoubeiCategory(parentCategoryId);
        if (category == null || category.size() <= 0) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        ArrayList newCategory = Lists.newArrayList();
        for (KoubeiCategoryModel model : category) {
            KoubeiResult result = new KoubeiResult();
            BeanUtils.copyProperties((Object)model, (Object)result);
            newCategory.add(result);
        }
        return BizResponse.success((Object)newCategory);
    }

    public BizResponse<List<KoubeiResult>> getALlKoubeiCategory() {
        List parentKoubeiCategories = this.fbKoubeiCategoryMapperExt.getKoubeiCategory("");
        if (parentKoubeiCategories == null || parentKoubeiCategories.size() <= 0) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        ArrayList koubeiResultList = Lists.newArrayList();
        for (KoubeiCategoryModel parentKoubeiCategorie : parentKoubeiCategories) {
            KoubeiResult result = new KoubeiResult();
            result.setCategoryId(parentKoubeiCategorie.getCategoryId());
            result.setParentCategoryId(parentKoubeiCategorie.getParentCategoryId());
            result.setRootCategoryId(parentKoubeiCategorie.getRootCategoryId());
            result.setName(parentKoubeiCategorie.getName());
            List koubeiCategories = this.fbKoubeiCategoryMapperExt.getKoubeiCategory(parentKoubeiCategorie.getParentCategoryId());
            result.setData(koubeiCategories);
            koubeiResultList.add(result);
        }
        return BizResponse.success((Object)koubeiResultList);
    }
}

