/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service;

import com.fshows.lifecircle.service.service.utils.AliOSSUtil;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliOssService {
    private static final Logger log = LoggerFactory.getLogger(AliOssService.class);

    public BizResponse<Boolean> uploadFile(String bucketName, String ossKey, String fileName) {
        if (AliOSSUtil.uploadFile(bucketName, ossKey, fileName)) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.REQUEST_METHOD_ERROR.getCode(), (String)ErrorCodeEnum.REQUEST_METHOD_ERROR.getMsg());
    }

    public BizResponse<Boolean> downloadFile(String bucketName, String key, String filename) {
        AliOSSUtil.downloadFile(bucketName, key, filename);
        return BizResponse.success((Object)true);
    }

    public BizResponse<String> fileUrl(String bucketName, String key) {
        String url = AliOSSUtil.fileUrl(bucketName, key);
        return BizResponse.success((Object)url);
    }

    public BizResponse<String> getToken(String bucketName, String key) {
        return BizResponse.success((Object)AliOSSUtil.getToken(bucketName, key));
    }
}

