package com.fshows.lifecircle.service.commons.openapi.facade.api;


import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.PVCSRusult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.openapi.facade.api
 * @description：描述
 * @updateDesription：更新记录描述
 * @date：2017/12/14
 * @author：Wendy
 */
public interface IApiPVSCode {
    /**
     * 获取静态图片验证码（base64加密码）
     *
     * @param channelType
     * @param height
     * @param width
     * @param count
     * @return
     */
    BizResponse<PVCSRusult> getPVSPngCode(Integer channelType, Integer height, Integer width, Integer count);

    /**
     * 验证
     *
     * @param channelType
     * @param token
     * @param code
     * @return
     */
    BizResponse<Boolean> checkCodeForChannel(Integer channelType, String token, String code);
}
