package com.fshows.lifecircle.service.commons.openapi.facade.api;

import com.fshows.lifecircle.service.commons.openapi.facade.domain.params.BankTypeListParam;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.params.OpenAccountParam;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.BankIdNameResult;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.BankInfoResult;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.BankTypeListResult;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.OpenAccountResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.exception.RpcInvokingException;

import java.util.List;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.openapi.facade.api
 * @description：描述:有关银行卡信息接口
 * @updateDesription：更新记录描述
 * @date：2018/1/18
 * @author：Wendy
 */
public interface IApiBankInfo {
    /**
     * @author: Wendy
     * @description:银行列表
     * @date: 14:05 2018/1/18
     */
    BizResponse<List<BankInfoResult>> getBanksByLetter(String letter);

    /**
     * 根据 名称模糊
     * @param letter
     * @return
     */
    BizResponse<List<BankInfoResult>> getBanksByFullName(String letter);

    /**
     * @author: Wendy
     * @description:根据卡号获取银行名称及bank_id
     * @date: 14:43 2018/1/18
     */
    BizResponse<BankIdNameResult> getBankIdNameResult(String BankNo);

    /**
     * 根据超级网银号获取银行卡详情
     * @param bankId
     * @return
     */
    BizResponse<BankInfoResult> getBankInfoByBankId(Long bankId);

    /**
     * 获取开户行
     * @param param
     * @return
     * @throws RpcInvokingException
     */
    BizResponse<List<OpenAccountResult>> getOpenAccount(OpenAccountParam param);

    /**
     * 手动选择银行列表（大小额）
     * @param param
     * @return
     */
    BizResponse<List<BankTypeListResult>> getBankTypeList(BankTypeListParam param);
}
