package com.fshows.lifecircle.service.commons.openapi.facade.api;


import com.fshows.lifecircle.service.commons.openapi.facade.domain.params.*;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.*;
import com.fshows.lifecircle.service.utils.domain.BizResponse;

/**
 * 功能：清算平台接口
 * 创建时间：2018-01-29 10:00
 *
 * @author caofy
 */
public interface ILiquidationApi {

    /**
     * 商户入驻清算平台（含进件资料）
     *
     * @return
     */
    BizResponse<LiquidationResult> liquidatorMerchantCreate(LiquidatorMerchantCreateParam param);


    /**
     * 清算平台商户入驻支付宝
     *
     * @return
     */
    BizResponse<AlipayMchAddResult> alipayMerchantCreate(AlipayMerchantCreateParam param);


    /**
     * 清算平台商户入驻微信
     *
     * @return
     */
    BizResponse<WxMchAddResult> wechatMerchantCreate(WechatMerchantCreateParam param);


    /**
     * 微信子商户配置
     *
     * @return
     */
    BizResponse<WxMchSetResult> wechatSubMerchantSet(WechatMerchantSetParam param);



    /**
     * 商户绑卡
     *
     * @return
     */
    BizResponse<MchBankBindResult> merchantBankBind(MchBankBindParam param);



}
