package com.fshows.lifecircle.service.commons.openapi.facade.domain.params;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.domain.models
 * @description：描述:推送参数转换
 * @updateDesription：更新记录描述
 * @date：2017/12/11
 * @author：Wendy
 */
@Data
public class ApiPushModel {
    private Long messageId;
    //推送id
    @NotBlank
    private String requestId;

    //用户id
    @NotNull
    private Long mid;

    @NotBlank
    private String targetValue;

    // 设备类型 1 ANDROID 2 iOS
    @NotNull
    private Integer deviceType;

    // 渠道类型 1 mipush 2 hvpush 3 gepush 4 ali
    @NotNull
    private Integer chennelId;

    // 消息的标题
    @NotBlank
    @Length(min = 1, max = 30, message = "消息标题过长")
    private String title;

    // 消息的副标题(描述)
    @Length(max = 128, message = "消息描述过长")
    private String description;

    // 消息的内容
    @NotBlank
    @Length(min = 1, max = 200, message = "消息内容过长")
    private String body;

    // 透传方式 1 透传 0 通知
    private Integer passThrough = Integer.valueOf(0);

    // 设置通知类型
    private Integer notifyType = Integer.valueOf(0);

    // 扩展信息
    private String extendContent;

    //点击通知后动作 1 : 打开应用 2 : 跳转"URL" 0 ：无跳转仅通知
    private Integer actionType = Integer.valueOf(1);

    //收到推送后打开对应的url
    private String actionUrl = "";

    //消息推送超时时间（单位：秒）
    private Integer timeOut = Integer.valueOf(10);

}
