package com.fshows.lifecircle.service.commons.openapi.facade.api;

import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.GaodeResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;

import java.util.List;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.openapi.facade.api
 * @description：描述
 * @updateDesription：更新记录描述
 * @date：2017/11/30
 * @author：Wendy
 */
public interface IApiGaodeCode {
    /**
     * @author: Wendy
     * @description:获取省信息
     * @date: 16:26 2017/11/30
     */
    BizResponse<List<GaodeResult>> getGaodeProvince();

    /**
     * @author: Wendy
     * @description:获取市信息
     * @date: 16:26 2017/11/30
     * @param province 省号
     * @return
     */
    BizResponse<List<GaodeResult>> getGaodeCity(String province);

    /**
     * @author: Wendy
     * @description:获取区信息
     * @date: 16:26 2017/11/30
     * @param city 市号
     * @return
     */
    BizResponse<List<GaodeResult>> getGaodeDiscrt(String city);

    /**
     * @author: Wendy
     * @description:获取高德全数据
     * @date: 16:26 2017/11/30
     */
    BizResponse<List<GaodeResult>> getGaodeAllData();

    /**
     * @author: Wangxj
     * @description:获取省市区Code
     * @date: 2018/1/31
     */
    BizResponse<GaodeResult> getSiteCode(String itude);
}
