package com.fshows.lifecircle.service.openapi.facade.domain.params;


import lombok.Data;


/**
 * 入驻到清算平台的参数对象
 */
@Data
public class LiquidatorMerchantCreateParam {

    /**
     * 清算方商户号
     */
    private String externalId;

    /*
      *商户名称
     */
    private String name;

    /**
     * 二级商户简称
     */
    private String aliasName;

    /**
     * 客服电话
     */
    private String servicePhone;

    /**
     * 联系人名称
     */
    private String contactName;

    /**
     * 联系人电话
     */
    private String contactPhone;

    /**
     * 联系人手机号
     */
    private String contactMobile;

    /**
     * 可联系人邮箱
     */
    private String contactEmail;

    /**
     * 经营类目
     */
    private String categoryId;

    /**
     * 商户来源机构标识
     */
    private String source;

    /**
     * 商户备注
     */
    private String memo;

    private String idCardName;

    private String idCardNum;

    private String storeAddress;

    private String idCardHandImgUrl;

    private String storeFrontImgUrl;

    private String businessLicenseImgUrl;

    /*  升级M2所需参数*/
    /*  省*/
    private String province;
    /*  市*/
    private String city;
    /*  区*/
    private String district;

    /*  升级M3所需参数*/
    /*  营业证件类型 */
    private String businessLicenseType;
    /*  商户证件编号 */
    private String businessLicense;

    /*  结算卡信息 */
    /**
     * 银行卡号
     */
    private String cardNo;

    /*  受理商负责人信息*/
    /*  类型*/
    private String contactType;


}
