package com.fshows.lifecircle.service.openapi.facade.api;


import com.fshows.lifecircle.service.openapi.facade.domain.params.AlipayMerchantCreateParam;
import com.fshows.lifecircle.service.openapi.facade.domain.params.LiquidatorMerchantCreateParam;
import com.fshows.lifecircle.service.openapi.facade.domain.params.WechatMerchantCreateParam;
import com.fshows.lifecircle.service.openapi.facade.domain.params.WechatMerchantSetParam;
import com.fshows.lifecircle.service.openapi.facade.domain.result.AlipayMchAddResult;
import com.fshows.lifecircle.service.openapi.facade.domain.result.LiquidationResult;
import com.fshows.lifecircle.service.openapi.facade.domain.result.WxMchAddResult;
import com.fshows.lifecircle.service.openapi.facade.domain.result.WxMchSetResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;

/**
 * 功能：清算平台接口
 * 创建时间：2018-12-29 10:00
 *
 * @author caofy
 */
public interface ILiquidationApi {

    /**
     * 商户入驻清算平台（含进件资料）
     *
     * @return
     */
    BizResponse<LiquidationResult> liquidatorMerchantCreate(LiquidatorMerchantCreateParam param);


    /**
     * 清算平台商户入驻支付宝
     *
     * @return
     */
    BizResponse<AlipayMchAddResult> alipayMerchantCreate(AlipayMerchantCreateParam param);


    /**
     * 清算平台商户入驻微信
     *
     * @return
     */
    BizResponse<WxMchAddResult> wechatMerchantCreate(WechatMerchantCreateParam param);


    /**
     * 微信子商户配置
     *
     * @return
     */
    BizResponse<WxMchSetResult> wechatSubMerchantSet(WechatMerchantSetParam param);


}
