package com.fshows.lifecircle.service.openapi.facade.api;


import com.fshows.lifecircle.service.openapi.facade.domain.result.AppModelResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.openapi.facade.api
 * @description：描述:阿里云oss存储
 * @updateDesription：更新记录描述
 * @date：2017/12/14
 * @author：Wendy
 */
public interface IApiOss {
    /**
     * 上传文件
     *
     * @param bucketName
     * @param ossKey
     * @param fileName
     * @return
     */
    BizResponse<Boolean> uploadFile(String bucketName, String ossKey, String fileName);

    /**
     * 下载文件
     * @param bucketName
     * @param key
     * @param filename
     * @return
     */
    BizResponse<Boolean> downloadFile(String bucketName, String key, String filename);

    /**
     * 下载文件url
     * @param bucketName
     * @param key
     * @return
     */
    BizResponse<String> fileUrl(String bucketName, String key);

    /**
     * @author: Wendy
     * @description:验签上传
     * @date: 15:47 2017/12/22
     */
    BizResponse<String> getToken(Integer imageType);

    /**
     * APP-OSS 服务
     * @return
     */
    BizResponse<AppModelResult> getTokenForApp();
}
