package com.fshows.lifecircle.service.openapi.facade.api;

import com.fshows.lifecircle.service.openapi.facade.domain.result.BankIdNameResult;
import com.fshows.lifecircle.service.openapi.facade.domain.result.BankInfoResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;

import java.util.List;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.openapi.facade.api
 * @description：描述:有关银行卡信息接口
 * @updateDesription：更新记录描述
 * @date：2018/1/18
 * @author：Wendy
 */
public interface IApiBankInfo {
    /**
     * @author: Wendy
     * @description:银行列表
     * @date: 14:05 2018/1/18
     */
    BizResponse<List<BankInfoResult>> getBanksByLetter(String letter);

    /**
     * @author: Wendy
     * @description:根据卡号获取银行名称及bank_id
     * @date: 14:43 2018/1/18
     */
    BizResponse<BankIdNameResult> getBankIdNameResult(String BankNo);
}
