package com.fshows.lifecircle.service.manager.formModels.liquidation;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 所在的包名: com.fshows.liquidator.platform.openapi.model.from.wx
 * 所在的项目名：liquidator-platform-openapi
 *
 * @Author:xukh
 * @Description:
 * @Date: Created in 13:59 2017/10/17
 */
@JsonNaming(PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy.class)
public class WechatMerchantSetForm extends BaseForm {

    //特约商户号
    @NotBlank
    private String storeId;

    @NotBlank
    private String payType;

    //授权目录
    private String jsapiPath;

    //关联APPID
    @Length(max = 32)
    private String subAppid;

    //推荐关注APPID
    @Length(max = 32)
    private String subscribeAppid;

    //可选参数
    private String subMchId;

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getJsapiPath() {
        return jsapiPath;
    }

    public void setJsapiPath(String jsapiPath) {
        this.jsapiPath = jsapiPath;
    }

    public String getSubAppid() {
        return subAppid;
    }

    public void setSubAppid(String subAppid) {
        this.subAppid = subAppid;
    }

    public String getSubscribeAppid() {
        return subscribeAppid;
    }

    public void setSubscribeAppid(String subscribeAppid) {
        this.subscribeAppid = subscribeAppid;
    }

    public String getSubMchId() {
        return subMchId;
    }

    public void setSubMchId(String subMchId) {
        this.subMchId = subMchId;
    }
}
