package com.fshows.lifecircle.service.manager.formModels.liquidation;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 所在的包名: com.fshows.liquidator.platform.openapi.model.from.wx
 * 所在的项目名：liquidator-platform-openapi
 *
 * @Author:xukh
 * @Description:
 * @Date: Created in 11:02 2017/10/17
 */
@JsonNaming(PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy.class)
public class WechatMerchantCreateForm extends BaseForm{

    //商户名称
    @NotBlank
    @Length(max = 50)
    private String merchantName;

    //商户简称
    @NotBlank
    @Length(max = 20)
    private String merchantShortname;

    //客服电话
    @NotBlank
    @Length(max = 20)
    private String servicePhone;

    //渠道号
    /*@NotBlank
    @Length(max = 32)
    private String channelId;*/

    //经营类目
    @NotBlank
    @Length(max = 10)
    private String business;

    //商户备注
    //@NotBlank
    @Length(max = 20)
    private String merchantRemark;

    //联系人
    @Length(max = 10)
    private String contact;

    //联系电话
    @Length(max = 11)
    private String contactPhone;

    //联系邮箱
    @Length(max = 30)
    private String contactEmail;

    //联系人微信账号类型
    //这个参数有值，必须确保contactWechatid也有值
    @Length(max = 32)
    private String contactWechatidType;

    //联系人微信帐号
    @Length(max = 32)
    private String contactWechatid;

    //账户类型  0.默认账户类型  1.小程序支付类型
    private String accountType;

    @NotBlank
    @Length(max = 20)
    private String storeId;

    @NotBlank
    private String payType;

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getMerchantShortname() {
        return merchantShortname;
    }

    public void setMerchantShortname(String merchantShortname) {
        this.merchantShortname = merchantShortname;
    }

    public String getServicePhone() {
        return servicePhone;
    }

    public void setServicePhone(String servicePhone) {
        this.servicePhone = servicePhone;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public String getMerchantRemark() {
        return merchantRemark;
    }

    public void setMerchantRemark(String merchantRemark) {
        this.merchantRemark = merchantRemark;
    }

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getContactEmail() {
        return contactEmail;
    }

    public void setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
    }

    public String getContactWechatidType() {
        return contactWechatidType;
    }

    public void setContactWechatidType(String contactWechatidType) {
        this.contactWechatidType = contactWechatidType;
    }

    public String getContactWechatid() {
        return contactWechatid;
    }

    public void setContactWechatid(String contactWechatid) {
        this.contactWechatid = contactWechatid;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }
}
