package com.fshows.lifecircle.service.manager.formModels.liquidation;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

;

/**
 * 所在的包名: com.fshows.liquidator.platform.openapi.model.from.liquidator
 * 所在的项目名：liquidator-platform-openapi
 *
 * @Author:xukh
 * @Description:
 * @Date: Created in 17:13 2017/11/14
 */
@SuppressWarnings("serial")
@JsonNaming(PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy.class)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class LiquidatorMerchantCreateForm extends BaseForm {

    /**二级商户编号(清算方商户号)*/
    @NotBlank(message = "二级商户编号不能为空")
    @Length(min = 1, max = 20, message = "二级商户编号过长")
    private String externalId;

    /**二级商户名称*/
    @NotBlank(message = "二级商户名称不能为空")
    @Length(min = 1, max = 64, message = "二级商户名称过长")
    private String name;

    /**二级商户简称*/
    @NotBlank(message = "二级商户简称不能为空")
    @Length(min = 1, max = 32)
    private String aliasName;

    /**客服电话*/
    @NotBlank(message = "客服电话不能为空")
    @Length(min = 1, max = 64)
    private String servicePhone;

    /**联系人名称*/
    @Length(max = 64)
    private String contactName;

    /**联系人电话*/
    @Length(max = 64)
    private String contactPhone;

    /**联系人手机号*/
    @Length(max = 64)
    private String contactMobile;

    /**可联系人邮箱*/
    @Email
    @Length(max = 128)
    private String contactEmail;

    /**经营类目*/
    @NotBlank(message = "经营类目不能为空")
    @Length(min = 1, max = 128)
    private String categoryId;

    /**商户来源机构标识*/
    private String source;

    /**商户备注*/
    @Length(max = 512)
    private String memo;

    @NotBlank
    @Length(max = 64)
    private String idCardName;

    @NotBlank
    @Length(max = 18)
    private String idCardNum;

    @NotBlank
    @Length(max = 255)
    private String storeAddress;

    @NotBlank
    @Length(max = 255)
    private String idCardHandImgUrl;

    @NotBlank
    @Length(max = 255)
    private String storeFrontImgUrl;

    @Length(max = 255)
    private String businessLicenseImgUrl;

    /*  升级M2所需参数*/
    /*  省*/
    @NotBlank
    @Length(max = 20)
    private String province;
    /*  市*/
    @NotBlank
    @Length(max = 20)
    private String city;
    /*  区*/
    @Length(max = 20)
    private String district;

    /*  升级M3所需参数*/
    /*  营业证件类型 */
    @Length(max = 32)
    private String businessLicenseType;
    /*  商户证件编号 */
    @Length(max = 32)
    private String businessLicense;

    /*  结算卡信息 */
    /** 银行卡号 */
    @Length(max = 32)
    private String cardNo;

    /*  受理商负责人信息*/
    /*  类型*/
    @Length(max = 32)
    private String contactType;


    public String getExternalId() {
        return externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAliasName() {
        return aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public String getServicePhone() {
        return servicePhone;
    }

    public void setServicePhone(String servicePhone) {
        this.servicePhone = servicePhone;
    }

    public String getContactName() {
        return contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getContactMobile() {
        return contactMobile;
    }

    public void setContactMobile(String contactMobile) {
        this.contactMobile = contactMobile;
    }

    public String getContactEmail() {
        return contactEmail;
    }

    public void setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
    }

    public String getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getIdCardName() {
        return idCardName;
    }

    public void setIdCardName(String idCardName) {
        this.idCardName = idCardName;
    }

    public String getIdCardNum() {
        return idCardNum;
    }

    public void setIdCardNum(String idCardNum) {
        this.idCardNum = idCardNum;
    }

    public String getStoreAddress() {
        return storeAddress;
    }

    public void setStoreAddress(String storeAddress) {
        this.storeAddress = storeAddress;
    }

    public String getIdCardHandImgUrl() {
        return idCardHandImgUrl;
    }

    public void setIdCardHandImgUrl(String idCardHandImgUrl) {
        this.idCardHandImgUrl = idCardHandImgUrl;
    }

    public String getStoreFrontImgUrl() {
        return storeFrontImgUrl;
    }

    public void setStoreFrontImgUrl(String storeFrontImgUrl) {
        this.storeFrontImgUrl = storeFrontImgUrl;
    }

    public String getBusinessLicenseImgUrl() {
        return businessLicenseImgUrl;
    }

    public void setBusinessLicenseImgUrl(String businessLicenseImgUrl) {
        this.businessLicenseImgUrl = businessLicenseImgUrl;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getBusinessLicenseType() {
        return businessLicenseType;
    }

    public void setBusinessLicenseType(String businessLicenseType) {
        this.businessLicenseType = businessLicenseType;
    }

    public String getBusinessLicense() {
        return businessLicense;
    }

    public void setBusinessLicense(String businessLicense) {
        this.businessLicense = businessLicense;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getContactType() {
        return contactType;
    }

    public void setContactType(String contactType) {
        this.contactType = contactType;
    }


}
