package com.fshows.lifecircle.service.manager.formModels.liquidation;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import org.hibernate.validator.constraints.Length;

/**
 * 项目：fs_liquidator_platform_openapi
 * 包名：com.fshows.liquidator.platform.openapi.controller.from
 * 功能：
 * 时间：2016-08-09
 * 作者：呱牛
 */
@SuppressWarnings("serial")
@JsonNaming(PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy.class)
public class BaseForm {

    private String appId;

    private String method;

    private String sign;

    private String version = "1.0";

    private String content;

    @Length(max = 255, message = "url过长")
    private String notifyUrl;

    public BaseForm() {

    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }
}
