package com.fshows.lifecircle.service.manager.formModels;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.domain.models
 * @description：描述:推送参数转换
 * @updateDesription：更新记录描述
 * @date：2017/12/11
 * @author：Wendy
 */
public class ApiPushModel {
    private Long messageId;
    //推送id
    @NotBlank
    private String requestId;

    //用户id
    @NotNull
    private Long mid;

    @NotBlank
    private String targetValue;

    // 设备类型 1 ANDROID 2 iOS
    @NotNull
    private Integer deviceType;

    // 渠道类型 1 mipush 2 hvpush 3 gepush 4 ali
    @NotNull
    private Integer chennelId;

    // 消息的标题
    @NotBlank
    @Length(min = 1, max = 30, message = "消息标题过长")
    private String title;

    // 消息的副标题(描述)
    @Length(max = 128, message = "消息描述过长")
    private String description;

    // 消息的内容
    @NotBlank
    @Length(min = 1, max = 200, message = "消息内容过长")
    private String body;

    // 透传方式 1 透传 0 通知
    private Integer passThrough = Integer.valueOf(0);

    // 设置通知类型
    private Integer notifyType = Integer.valueOf(0);

    // 扩展信息
    private String extendContent;

    //点击通知后动作 1 : 打开应用 2 : 跳转"URL" 0 ：无跳转仅通知
    private Integer actionType = Integer.valueOf(1);

    //收到推送后打开对应的url
    private String actionUrl = "";

    //消息推送超时时间（单位：秒）
    private Integer timeOut = Integer.valueOf(10);

    public Long getMessageId() {
        return messageId;
    }

    public void setMessageId(Long messageId) {
        this.messageId = messageId;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }

    public String getTargetValue() {
        return targetValue;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public Integer getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    public Integer getChennelId() {
        return chennelId;
    }

    public void setChennelId(Integer chennelId) {
        this.chennelId = chennelId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Integer getPassThrough() {
        return passThrough;
    }

    public void setPassThrough(Integer passThrough) {
        this.passThrough = passThrough;
    }

    public Integer getNotifyType() {
        return notifyType;
    }

    public void setNotifyType(Integer notifyType) {
        this.notifyType = notifyType;
    }

    public String getExtendContent() {
        return extendContent;
    }

    public void setExtendContent(String extendContent) {
        this.extendContent = extendContent;
    }

    public Integer getActionType() {
        return actionType;
    }

    public void setActionType(Integer actionType) {
        this.actionType = actionType;
    }

    public String getActionUrl() {
        return actionUrl;
    }

    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public Integer getTimeOut() {
        return timeOut;
    }

    public void setTimeOut(Integer timeOut) {
        this.timeOut = timeOut;
    }

    @Override
    public String toString() {
        return "ApiPushModel{" +
                "messageId=" + messageId +
                ", requestId='" + requestId + '\'' +
                ", mid=" + mid +
                ", targetValue='" + targetValue + '\'' +
                ", deviceType=" + deviceType +
                ", chennelId=" + chennelId +
                ", title='" + title + '\'' +
                ", description='" + description + '\'' +
                ", body='" + body + '\'' +
                ", passThrough=" + passThrough +
                ", notifyType=" + notifyType +
                ", extendContent='" + extendContent + '\'' +
                ", actionType=" + actionType +
                ", actionUrl='" + actionUrl + '\'' +
                ", timeOut=" + timeOut +
                '}';
    }

}
