/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.liquidationcore.facade.enums.common;

import org.apache.commons.lang3.StringUtils;

public enum PayPlatformEnum {
    WECHAT("\u5fae\u4fe1", "WECHAT", 1, "WXZF", "2", "WECHAT", "WECHAT", "WECHAT", "WECHAT"),
    ALIPAY("\u652f\u4ed8\u5b9d", "ALIPAY", 2, "ZFBZF", "1", "ALIPAY", "ALIPAY", "ALIPAY", "ALIPAY"),
    UNIONPAY("\u94f6\u8054\u4e91\u95ea\u4ed8", "UNIONPAY", 5, "UPSMZF", "6", "UQRCODEPAY", "UNIONPAY", "CUP", "UNIONPAY"),
    POS("POS", "BANK_CARD", 9, "", "8", null, null, null, null),
    DCEP("\u6570\u5b57\u4eba\u6c11\u5e01", "DCEP", 40, "", "16", null, null, null, null),
    PRE_PAY_CARD("\u9884\u4ed8\u5361\u652f\u4ed8", "PRE_PAY_CARD", null, "", "17", null, null, null, null),
    WANDA_COUPON_WRITE_OFF("\u4e07\u8fbe\u5361\u5238\u6838\u9500", "WANDA_COUPON_WRITE_OFF", 32, "", "", null, null, null, null),
    UNKNOW("\u672a\u77e5", "UNKNOW", null, "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW");

    private final String name;
    private final String value;
    private final Integer payType;
    private final String lsValue;
    private final String umpayValue;
    private final String lklValue;
    private final String yeepayValue;
    private final String xftValue;
    private final String fuiouValue;

    private PayPlatformEnum(String name, String value, Integer payType, String lsValue, String umpayValue, String lklValue, String yeepayValue, String xftValue, String fuiouValue) {
        this.name = name;
        this.value = value;
        this.payType = payType;
        this.lsValue = lsValue;
        this.umpayValue = umpayValue;
        this.lklValue = lklValue;
        this.yeepayValue = yeepayValue;
        this.xftValue = xftValue;
        this.fuiouValue = fuiouValue;
    }

    public static PayPlatformEnum getByValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByPayType(Integer payType) {
        PayPlatformEnum[] values;
        if (null == payType) {
            return UNKNOW;
        }
        for (PayPlatformEnum value : values = PayPlatformEnum.values()) {
            if (!value.getPayType().equals(payType)) continue;
            return value;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByLsValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getLsValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByUmpayValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getUmpayValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByLklValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getLklValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByYeepayValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getYeepayValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByXftValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getXftValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByFuiouValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getFuiouValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getPayType() {
        return this.payType;
    }

    public String getLsValue() {
        return this.lsValue;
    }

    public String getUmpayValue() {
        return this.umpayValue;
    }

    public String getLklValue() {
        return this.lklValue;
    }

    public String getYeepayValue() {
        return this.yeepayValue;
    }

    public String getXftValue() {
        return this.xftValue;
    }

    public String getFuiouValue() {
        return this.fuiouValue;
    }
}

