/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.liquidationcore.facade.enums.common;

import org.apache.commons.lang3.StringUtils;

public enum TradeStateEnum {
    TRADE_SUCCESS("\u6d5c\u3086\u69d7\u93b4\u612c\u59db", "SUCCESS"),
    TRADE_FAIL("\u6d5c\u3086\u69d7\u6fb6\u8fab\u89e6", "FAIL"),
    TRADE_PAYING("\u93c0\ue219\u7caf\u6d93\ufffd", "PAYING"),
    TRADE_NOTPAY("\u93c8\ue045\u656e\u6d60\ufffd", "NOTPAY"),
    TRADE_CLOSED("\u5bb8\u63d2\u53e7\u95c2\ufffd", "CLOSED"),
    TRADE_CANCELED("\u5bb8\u53c9\u6319\u95bf\ufffd", "CANCELED"),
    REFUND_SUCCESS("\u95ab\ufffd\u5a06\u70ac\u579a\u9354\ufffd", "REFUND_SUCCESS"),
    REFUND_FAIL("\u95ab\ufffd\u5a06\u60e7\u3051\u7490\ufffd", "REFUND_FAIL"),
    REFUND_PROCESSING("\u95ab\ufffd\u5a06\u53e5\u8151", "REFUND_PROCESSING");

    private String name;
    private String tradeState;

    private TradeStateEnum(String name, String tradeState) {
        this.name = name;
        this.tradeState = tradeState;
    }

    public static TradeStateEnum getByValue(String value) {
        TradeStateEnum[] valueList;
        for (TradeStateEnum v : valueList = TradeStateEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getTradeState(), (CharSequence)value)) continue;
            return v;
        }
        return TRADE_PAYING;
    }

    public String getName() {
        return this.name;
    }

    public String getTradeState() {
        return this.tradeState;
    }
}

