/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.iotcore.facade.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PayTypeEnum {
    WECHAT_PAY("\u5fae\u4fe1", Arrays.asList(1, 11, 12), "/data/image/wx.png"),
    ALIPAY_PAY("\u652f\u4ed8\u5b9d", Arrays.asList(2, 7, 21, 22), "/data/image/alip.png"),
    UNION_PAY("\u94f6\u8054", Collections.singletonList(5), "/data/image/union.png"),
    BANKCARD_PAY("\u94f6\u884c\u5361", Collections.singletonList(9), "/data/image/union.png");

    private String name;
    private List<Integer> value;
    private String icon;

    private PayTypeEnum(String name, List<Integer> value, String icon) {
        this.name = name;
        this.value = value;
        this.icon = icon;
    }

    public static PayTypeEnum getByValue(Integer value) {
        PayTypeEnum[] valueList;
        for (PayTypeEnum v : valueList = PayTypeEnum.values()) {
            if (!v.getValue().contains(value)) continue;
            return v;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public List<Integer> getValue() {
        return this.value;
    }

    public String getIcon() {
        return this.icon;
    }
}

