/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.datacore.facade.domain.response;

import com.fshows.lifecircle.datacore.facade.domain.request.PageBaseRequest;
import com.google.common.collect.Lists;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageResult<T>
extends PageBaseRequest {
    private static final long serialVersionUID = 8962929234145659695L;
    private long total;
    private List<T> list;

    public PageResult() {
        this.total = 0L;
        this.page = 1;
        this.pageSize = 10;
        this.list = Lists.newArrayList();
    }

    public PageResult(int total, List<T> list) {
        this.total = total;
        this.list = list;
        if (null == list) {
            this.list = Lists.newArrayList();
        }
    }

    public PageResult(int page, int pageSize, long total, List<T> returnDo) {
        this.page = page;
        this.pageSize = pageSize;
        this.total = total;
        this.list = returnDo;
    }

    public static <T> PageResult<T> newBasePageResult(int total, List<T> list) {
        return new PageResult<T>(total, list);
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<T> this$list = this.getList();
        List<T> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        List<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PageResult(total=" + this.getTotal() + ", list=" + this.getList() + ")";
    }
}

