/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.datacore.facade.domain.response.agent;

import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;

public class ApiPageResponse<T>
implements Serializable {
    private static final long serialVersionUID = -3208432208135922791L;
    private Integer page;
    private Integer pageSize;
    private List<T> list;
    private long total;

    public ApiPageResponse() {
        this.total = 0L;
        this.page = 1;
        this.pageSize = 10;
        this.list = Lists.newArrayList();
    }

    public ApiPageResponse(int total, List<T> list) {
        this.total = total;
        this.list = list;
        if (null == list) {
            this.list = Lists.newArrayList();
        }
    }

    public ApiPageResponse(int page, int pageSize, long total, List<T> returnDo) {
        this.page = page;
        this.pageSize = pageSize;
        this.total = total;
        this.list = returnDo;
    }

    public ApiPageResponse(PageInfo pageInfo) {
        this.page = pageInfo.getPageNum();
        this.pageSize = pageInfo.getPageSize();
        this.total = pageInfo.getTotal();
        this.list = pageInfo.getList();
    }

    public ApiPageResponse(PageInfo pageInfo, List<T> returnDo) {
        this.page = pageInfo.getPageNum();
        this.pageSize = pageInfo.getPageSize();
        this.total = pageInfo.getTotal();
        this.list = returnDo;
    }

    public static <T> ApiPageResponse<T> newBasePageResult(int total, List<T> list) {
        return new ApiPageResponse<T>(total, list);
    }

    public Integer getPage() {
        return this.page;
    }

    public ApiPageResponse<T> setPage(Integer page) {
        this.page = page;
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public ApiPageResponse<T> setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }
}

