/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.util;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);
    public static final String DEFAULT_VERSION = "2.0";
    public static final String SING_PREFIX = "lepos";
    public static final String DEFAULT_CHARSET = "utf-8";

    public static <T> String getMerchantSign(LeshuaBizRequest<T> request, String privateKey) throws LeshuaException {
        String jsonData = JSON.toJSONString(request);
        StringBuffer sb = new StringBuffer(SING_PREFIX);
        sb.append(privateKey).append(jsonData);
        return SignUtil.doSign(sb.toString());
    }

    public static <T> String getSubsidySign(String request, String privateKey) throws LeshuaException {
        StringBuffer signStr = new StringBuffer();
        signStr.append(request).append(privateKey);
        String sign = "";
        try {
            sign = DigestUtils.md5Hex((byte[])signStr.toString().getBytes(DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u7b7e\u540d\u5f02\u5e38,ex={}", (Throwable)e);
            throw new LeshuaException("\u7b7e\u540d\u5f02\u5e38", e);
        }
        log.info("\u5f85\u7b7e\u53c2\u6570:{},\u7b7e\u540d\u503c:{}", (Object)signStr, (Object)sign);
        return sign;
    }

    public static <T> String getAgentVoiceSign(LeshuaBizRequest<T> request, String reqSerialNo, String privateKey) throws LeshuaException {
        String jsonData = JSON.toJSONString(request);
        StringBuffer sb = new StringBuffer();
        sb.append(privateKey).append(reqSerialNo).append(DEFAULT_VERSION).append(jsonData);
        return SignUtil.agentVoiceDoSign(sb.toString());
    }

    public static String getSettlementOrderSign(String requestJson, String privateKey) throws LeshuaException {
        StringBuffer sb = new StringBuffer(SING_PREFIX);
        sb.append(privateKey).append(requestJson);
        return SignUtil.doSign(sb.toString());
    }

    public static String getSignWithReqSerialNoAndVersion(String content, String privateKey, String reqSerialNo, String version) throws LeshuaException {
        StringBuilder sb = new StringBuilder();
        sb.append(privateKey);
        if (ObjectUtil.isNotNull((Object)reqSerialNo)) {
            sb.append(reqSerialNo);
        }
        if (ObjectUtil.isNotNull((Object)version)) {
            sb.append(version);
        }
        sb.append(content);
        try {
            return DigestUtils.md5Hex((byte[])sb.toString().getBytes(DEFAULT_CHARSET));
        }
        catch (Exception e) {
            log.error("\u7b7e\u540d\u5f02\u5e38,ex={}", (Throwable)e);
            throw new LeshuaException("\u7b7e\u540d\u5f02\u5e38", e);
        }
    }

    public static String doSign(String signStr) throws LeshuaException {
        String sign = "";
        try {
            String md5 = DigestUtils.md5Hex((byte[])signStr.getBytes(DEFAULT_CHARSET));
            sign = Base64.encodeBase64String((byte[])md5.getBytes(DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u7b7e\u540d\u5f02\u5e38,ex={}", (Throwable)e);
            throw new LeshuaException("\u7b7e\u540d\u5f02\u5e38", e);
        }
        log.info("\u5f85\u7b7e\u53c2\u6570:{},\u7b7e\u540d\u503c:{}", (Object)signStr, (Object)sign);
        return sign;
    }

    public static String agentVoiceDoSign(String signStr) throws LeshuaException {
        String sign = "";
        try {
            sign = DigestUtils.md5Hex((byte[])signStr.getBytes(DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u7b7e\u540d\u5f02\u5e38,ex={}", (Throwable)e);
            throw new LeshuaException("\u7b7e\u540d\u5f02\u5e38", e);
        }
        log.info("\u5f85\u7b7e\u53c2\u6570:{},\u7b7e\u540d\u503c:{}", (Object)signStr, (Object)sign);
        return sign;
    }
}

