/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.activity;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.activity.LeshuaQuerySubsidyResponse;
import lombok.Data;

/**
 * 服务商补贴批次查询
 *
 * @author linzy
 * @version LeshuaQuerySubsidyRequest.java, v 0.1 2022-10-10 上午9:29 linzy
 */
@Data
@JSONType(naming = PropertyNamingStrategy.PascalCase)
public class LeshuaQuerySubsidyRequest extends LeshuaBizRequest<LeshuaQuerySubsidyResponse> {

    /**
     * 补贴信息上传批次号（同一代理商和期望补贴日期，再次上传时需要传入此参数）
     */
    private String subsidyId;

    @Override
    public Class<LeshuaQuerySubsidyResponse> getResponseClass() {
        return LeshuaQuerySubsidyResponse.class;
    }
}