package com.fshows.leshuapay.sdk.enums;

import cn.hutool.core.util.StrUtil;

/**
 * @author songjian * @version MerchantReceiptEnum.java, v 0.1 2025-04-17 14:57 songjian
 */
public enum MerchantReceiptEnum {
    CREATE_MERCHANT_RECEIPT("商户打款电子回单查询", "/merchantReceipt/createMerchantReceipt"),
    ;

    private String name;
    private String value;

    MerchantReceiptEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static MerchantReceiptEnum getByValue(String value) {
        MerchantReceiptEnum[] valueList = MerchantReceiptEnum.values();
        for (MerchantReceiptEnum v : valueList) {
            if (StrUtil.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}