/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 商户支付参数配置request
 *
 * @author zhaoyi
 * @version MerchantWxPayConfigRequest.java, v 0.1 2020-07-29 11:50 zhaoyi
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantWxPayConfigRequest extends LeshuaBizRequest<LeshuaBaseResponse> {

    /**
     * 商户编号
     */
    @NotBlank(message = "merchantId不能为空")
    @Length(max = 10, message = "merchantId超长")
    private String merchantId;

    /**
     * 商户渠道号ID
     * 商户上报的微信渠道号ID（只有一个渠道号无需填写此字段）
     */
    private Integer reportConfigId;

    /**
     * 微信商户号
     * 参加绿洲后，配置参数必填
     */
    @Length(max = 10, message = "wxSubMchId超长")
    private String wxSubMchId;

    /**
     * 配置类型：1：绑定APPID（支付）；2：推荐关注APPID；3：授权目录；
     */
    @NotNull
    private Integer configType;

    /**
     * 绑定APPID
     * 绑定APPID，configType为1、2时必填
     */
    @Length(max = 18, message = "subAppid超长")
    @JSONField(name = "sub_appid")
    private String subAppid;

    /**
     * 推荐关注公众号APPID
     */
    @Length(max = 18, message = "subscribeAppid超长")
    @JSONField(name = "subscribe_appid")
    private String subscribeAppid;

    /**
     * 推荐关注小程序APPID
     */
    @Length(max = 18, message = "receiptAppid超长")
    @JSONField(name = "receipt_appid")
    private String receiptAppid;

    /**
     * 授权目录
     */
    @JSONField(name = "jsapi_path")
    private String jsapiPath;

    @Override
    public Class<LeshuaBaseResponse> getResponseClass() {
        return LeshuaBaseResponse.class;
    }

}
