/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.settlement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.settlement.MerchantGetWithdrawFeeResponse;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;

/**
 * 商户账户提现费率查询 request
 *
 * @author zhaoxumin
 * @version MerchantGetWithdrawFeeRequest.java, v 0.1 2024-03-29 zhaoxumin
 */
@Data
public class MerchantGetWithdrawFeeRequest extends LeshuaBizRequest<MerchantGetWithdrawFeeResponse> {

    private static final long serialVersionUID = -4422923073967754403L;
    /**
     * 乐刷商编
     */
    @NotBlank(message = "乐刷商编不能为空")
    private String merchantId;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantGetWithdrawFeeResponse> getResponseClass() {
        return MerchantGetWithdrawFeeResponse.class;
    }
}
