/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.share;

import cn.hutool.core.util.StrUtil;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 多次分账查询
 *
 * @author linzy
 * @version QueryResponse.java, v 0.1 2021-05-06 11:50 linzy
 */
@Data
public class MultiQueryResponse implements Serializable {

    private static final long serialVersionUID = 7759227247867476190L;

    /**
     * 错误码
     */
    private String retcode;

    /**
     * 错误信息
     */
    private String retmsg;

    /**
     * 分账详情
     */
    private String royaltyRecords;

    public static void main(String[] args) {
        String s = "20230129142829243600\t郑州市朗铭文化传播有限公司\t20230118141454070489\t0.720000000\t1357791\t儿童花园游乐网红店（C-LM）\t20230129142839283079\n" +
                "20230129142829243600\t郑州市朗铭文化传播有限公司\t20230118141454070489\t0.720000000\t1357603\t儿童花园游乐旋转木马（C-LM）\t20230129142839283079\n" +
                "20230129142829243600\t郑州市朗铭文化传播有限公司\t20230118141454070489\t0.720000000\t1357594\t儿童花园游乐碰碰车（C-LM）\t20230129142839283079\n" +
                "20230129142829243600\t郑州市朗铭文化传播有限公司\t20230118141454070489\t0.720000000\t1357549\t儿童花园游乐迷你穿梭（C-LM）\t20230129142839283079\n" +
                "20230129142829243600\t郑州市朗铭文化传播有限公司\t20230118141454070489\t0.720000000\t1357537\t儿童花园游乐大炮乐园（C-LM）\t20230129142839283079\n" +
                "20230129142829243600\t郑州市朗铭文化传播有限公司\t20230118141454070489\t0.820000000\t1357491\t儿童花园美食6号店（C-LM）\t20230129142839283079\n" +
                "20230129142829243600\t郑州市朗铭文化传播有限公司\t20230118141454070489\t0.820000000\t1357487\t儿童花园美食5号店（C-LM）\t20230129142839283079\n" +
                "20230129142829243600\t郑州市朗铭文化传播有限公司\t20230118141454070489\t0.820000000\t1357486\t儿童花园美食4号店（C-LM）\t20230129142839283079\n" +
                "20230129142829243600\t郑州市朗铭文化传播有限公司\t20230118141454070489\t0.820000000\t1357447\t儿童花园美食3号店（C-LM）\t20230129142839283079\n" +
                "20230129142829243600\t郑州市朗铭文化传播有限公司\t20230118141454070489\t0.820000000\t1357446\t儿童花园美食2号店（C-LM）\t20230129142839283079\n" +
                "20230129142829243600\t郑州市朗铭文化传播有限公司\t20230118141454070489\t0.820000000\t1357445\t儿童花园美食1号店（C-LM）\t20230129142839283079\n" +
                "20230129143317535431\t任鸿杰\t20230118141454070489\t0.800000000\t1356298\t沈阳园餐饮\t20230129143329556260\n" +
                "20230129145048501544\t河南泓铭旅游开发有限公司\t20230118141454070489\t0.700000000\t1356100\t休闲观光车\t20230129145059024551\n" +
                "20230129145624088012\t王文飞\t20230118141454070489\t0.800000000\t1357019\t锦茶奶茶店\t20230129145636401426\n" +
                "20230129150942830043\t张晓红\t20230118141454070489\t0.800000000\t1357067\t海口园便利店\t20230129150954261263\n" +
                "20230129151341109746\t焦延敏\t20230118141454070489\t0.800000000\t1357020\t柚子餐饮店\t20230129151350025704\n" +
                "20230129151829361304\t焦艳燕\t20230118141454070489\t0.700000000\t1357035\t柚子游乐园\t20230129151839590002\n" +
                "20230129163328616387\t丁鑫\t20230118141454070489\t0.700000000\t1356193\t丁鑫游乐场\t20230129163338385192\n" +
                "20230129164747886676\t王杰\t20230118141454070489\t0.800000000\t1356390\t同心便利店\t20230129164800971753\n" +
                "20230129165357986719\t王宁\t20230118141454070489\t0.500000000\t1360212\tDIY手工（L-WN）\t20230129165407817251\n" +
                "20230129165357986719\t王宁\t20230118141454070489\t0.500000000\t1360211\tDIY木工（L-WN）\t20230129165407817251\n" +
                "20230130173058754316\t河南大豫汉风酒店管理有限公司\t20230118141454070489\t0.700000000\t1357268\t观光小火车(HFYY)\t20230130173105362147\n" +
                "20230130173058754316\t河南大豫汉风酒店管理有限公司\t20230118141454070489\t0.850000000\t1357267\t长沙臭豆腐(HFYY)\t20230130173105362147\n" +
                "20230130173058754316\t河南大豫汉风酒店管理有限公司\t20230118141454070489\t0.850000000\t1357266\t大脸鸡排（HFYY）\t20230130173105362147\n" +
                "20230130173058754316\t河南大豫汉风酒店管理有限公司\t20230118141454070489\t0.850000000\t1357265\t旋风薯塔(HFYY)\t20230130173105362147\n" +
                "20230130173058754316\t河南大豫汉风酒店管理有限公司\t20230118141454070489\t0.850000000\t1357264\t冰淇淋与茶(HFYY)\t20230130173105362147\n" +
                "20230130173058754316\t河南大豫汉风酒店管理有限公司\t20230118141454070489\t0.850000000\t1357263\t千与千寻(HFYY)\t20230130173105362147\n";

        String sql1 = "INSERT INTO `tp_share_rule` (`share_member_id`,`store_id`,`share_portion`,`last_share_portion`,`begin_time`,`is_del`) " +
                "VALUES ('{}',{},{},1,0,0);";

        String[] rowList = StringUtils.split(s, "\n");
        for(String row:rowList) {
            String[] data = StringUtils.split(row, "\t");
            System.out.println(StrUtil.format(sql1, data[6], data[4], new BigDecimal(data[3]).setScale(2, BigDecimal.ROUND_HALF_DOWN).toString()));
        }
    }
}
