/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.leshuapay.sdk.response.share;

import lombok.Data;

import java.io.Serializable;

/**
 *
 * @author liluqing
 * @version CancleSumAccreditResponse.java, v 0.1 2023-10-24 18:32
 */
@Data
public class CancleSumAccreditResponse implements Serializable {

    private static final long serialVersionUID = -2764026027501082033L;

    /**
     * 业务应答码
     * 0表示业务受理成功，分账成功需要看status
     * 其他表示业务受理失败
     */
    private String retcode;

    /**
     * 业务应答说明
     * 业务受理成功时返回“success”
     */
    private String retmsg;

    /**
     * 商户分账单号
     * retcode=0时返回
     */
    private String thirdId;

    /**
     * 乐刷分账单号
     * retcode=0时返回
     */
    private String leshuaId;

    /**
     * 分账方的乐刷商户号
     * retcode=0时返回
     */
    private String merchantId;

    /**
     * 分账状态，枚举如下：
     * 0：处理中
     * 1：分账成功
     * 2：分账失败
     * 3：分账撤销中
     * 4：分账撤销成功
     * 5：分账撤销失败
     * 说明：分账成功后，资金次日统一出款
     * retcode=0时返回
     */
    private String status;
}