/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.leshuapay.sdk.request.share;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.CancleSumAccreditResponse;
import lombok.Data;

/**
 * 余额分账撤销
 * @author liluqing
 * @version CancleSumAccreditReqeust.java, v 0.1 2023-10-24 18:27
 */
@Data
public class CancleSumAccreditReqeust  extends LeshuaBizRequest<CancleSumAccreditResponse> {

    /**
     * 服务名称，本处固定为：balance_allot_cancel
     */
    private String cmd = "balance_allot_cancel";

    /**
     * 分账方的乐刷商户编号
     */
    @JSONField(name = "merchant_id")
    private String merchantId;

    /**
     * 商户分账单号
     */
    @JSONField(name = "third_id")
    private String thirdId;

    @Override
    public Class<CancleSumAccreditResponse> getResponseClass() {
        return CancleSumAccreditResponse.class;
    }
}