/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.leshuapay.sdk.request.share;

import lombok.Data;

/**
 *
 * @author liluqing
 * @version AccreditShareRateRequest.java, v 0.1 2024-08-19 下午4:16
 */
@Data
public class AccreditShareRateRequest {

    /**
     * 收费方式，枚举
     *      1：比例
     *      2：固定金额：
     *      3：比例+固定金额
     */
    private Integer tradeType;

    /**
     * 手续费费率，tradeType=1或者3时，该字段必填，单位万分之一
     */
    private Integer feeRate;

    /**
     * 固定金额收费。
     * tradeType=2或者3时，该字段必填，单位万分，即1万=1分钱，1百万=1元钱
     */
    private Integer fixed;
}