/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 商户信息修改request
 *
 * @author zhaoyi
 * @version MerchantSettleRequest.java, v 0.1 2020-07-27 11:50 zhaoyi
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantQryInfoRequest extends LeshuaBizRequest<LeshuaBaseResponse> {

    @NotBlank(message = "merchantId不能为空")
    @Length(max = 10, message = "merchantId超长")
    private String merchantId;

    @Override
    public Class<LeshuaBaseResponse> getResponseClass() {
        return LeshuaBaseResponse.class;
    }
}
