/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.settlement.MerchantInfoSupplementQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author mengqf
 * @version MerchantInfoSupplementQueryRequest.java, v 0.1 2024-10-12 15:27 mengqf
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantInfoSupplementQueryRequest extends LeshuaBizRequest<MerchantInfoSupplementQueryResponse> {

    @NotBlank(message = "merchantId不能为空")
    @Length(max = 10, message = "merchantId超长")
    private String merchantId;

    /**
     * 业务类型，枚举如下：
     * 分账-ledger
     * 提现秒到-withdrawalAtOnce
     * 提现九点到-withdrawal9hourBatch
     */
    private String businessType;

    @Override
    public Class<MerchantInfoSupplementQueryResponse> getResponseClass() {
        return MerchantInfoSupplementQueryResponse.class;
    }
}