/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.rate;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 商户设置费率request
 *
 * @author zhaoyi
 * @version MerchantWxApplyRequest.java, v 0.1 2020-07-29 14:50 zhaoyi
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantRateRequest extends LeshuaBizRequest<LeshuaBaseResponse> {

    /**
     * 商户编号
     */
    @NotBlank(message = "merchantId不能为空")
    @Length(max = 10, message = "merchantId超长")
    private String merchantId;
    /**
     * 生效方式
     * 0或不传：立即生效
     * 2：次日生效
     * 5：当日生效
     */
    private Integer effectiveType;

    /**
     * 微信扫码费率
     */
    private WxRate weixin;

    /**
     * 支付宝扫码费率
     */
    private AlipayRate alipay;

    /**
     * 刷卡费率
     */
    private CardRate card;

    /**
     * 银联扫码费率-大于1000
     */
    private UnionScanRate unionScan;

    /**
     * 银联扫码费率-小于等于1000
     */
    private UnionScan2Rate unionScan2;


    @Override
    public Class<LeshuaBaseResponse> getResponseClass() {
        return LeshuaBaseResponse.class;
    }

}
