/**
 * fshows.com Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.MerchantInfoUpdateShortnameResponse;
import lombok.Data;

/**
 * 商户信息查询request
 *
 * @author zhaoyi
 * @version MerchantInfoQueryRequest.java, v 0.1 2020-07-30 11:59 zhaoyi
 */
@Data
public class MerchantAlipayUpdateShortnameRequest
        extends LeshuaBizRequest<MerchantInfoUpdateShortnameResponse> {

    /** 商户编号 */
    private String merchantId;

    /** 支付宝子商户号 */
    private String zfbSubMchId;

    @Override
    public Class<MerchantInfoUpdateShortnameResponse> getResponseClass() {
        return MerchantInfoUpdateShortnameResponse.class;
    }
}
