/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.basic;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author zhaoyi
 * @version BankBranch.java, v 0.1 2020-07-30 09:05 zhaoyi
 */
@Data
public class BankBranch implements Serializable {
    private static final long serialVersionUID = -3714708443049687360L;

    /**
     * 银联标准省份代码
     */
    private String cftProvinceCode;

    /**
     * 银联标准省份名称
     */
    private String cftProvinceName;

    /**
     * 银联标准城市代码
     */
    private String cftCityCode;

    /**
     * 银联标准城市名称
     */
    private String cftCityName;

    /**
     * 联行号
     */
    private String unionpayCode;

    /**
     * 所在省份
     */
    private String bankArea;

    /**
     * 所在城市
     */
    private String bankCity;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 支行名称
     */
    private String branchName;

    /**
     * 金融机构码值
     */
    private String finInstitutionCode;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
