/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.share;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 营业执照信息
 *
 * @author linzy
 * @version LicenseInfo.java, v 0.1 2021-05-06 14:50 linzy
 */
@Data
public class LicenseInfo implements Serializable {

    private static final long serialVersionUID = -6343556628931362766L;

    /**
     * 营业执照商户全称（必须与商户号匹配）
     */
    @Length(max = 40, message = "营业执照名称超长")
    private String licenseFullName;
}
