/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.share;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.LeshuaShareRefundResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 分账退款
 *
 * @author linzy
 * @version RefundRequest.java, v 0.1 2021-05-06 11:50 linzy
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LeshuaShareRefundRequest extends LeshuaBizRequest<LeshuaShareRefundResponse> {

    /**
     * 商户号
     * 由乐刷分配
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 第三方订单号
     */
    private String thirdOrderId;

    /**
     * 乐刷交易订单号
     */
    private String leshuaOrderId;

    /**
     * 退款金额，单位：分
     */
    private BigDecimal refundAmount;

    /**
     * 第三方退款单号
     */
    private String thirdRefundId;

    /**
     * 第三方分账单号
     */
    private String thirdRoyaltyId;

    /**
     * 乐刷分账单号
     */
    private String leshuaRoyaltyId;

    /**
     * 回调地址
     */
    private String notifyUrl;

    @Override
    public Class<LeshuaShareRefundResponse> getResponseClass() {
        return LeshuaShareRefundResponse.class;
    }
}
