/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.pay;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 订单关闭请求
 * @author xiaotian
 * @version LeshuaOrderCloseRequest.java, v 0.1 2020-07-29 9:39
 */
@Data
public class LeshuaOrderCloseRequest extends LeshuaBasePayRequest{

    /**
     * 接口名
     */
    private String service = "close_order";

    /**
     * 乐刷分配的商户号
     **/
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 商户订单号
     **/
    private String thirdOrderId;

    /**
     * 乐刷订单号
     */
    private String leshuaOrderId;
}

