/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.merchant;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.util.List;

/**
 * 商户上报情况
 * 微信/支付宝/银联商户号查询response
 *
 * @author zhaoyi
 * @version MerchantSubMchQueryResponse.java, v 0.1 2020-07-29 12:15 zhaoyi
 */
@Data
public class MerchantSubMchQueryResponse implements Serializable {

    private static final long serialVersionUID = -3353530187829029101L;

    private String merchantId;

    private List<WechatReportInfo> wechat;

    private List<AlipayReportInfo> alipay;

    private List<UnionscanReportInfo> unionscan;

    private List<UnionpayQRAReportInfo> unionpayQRA;

    private List<CupsReportInfo> cups;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
