/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author zhaoyi
 * @version LeshuaBaseResponse.java, v 0.1 2020-07-23 12:03 zhaoyi
 */
@Data
public class LeshuaBaseResponse<R> implements Serializable {

    private static final long serialVersionUID = -3682390141371363265L;

    private String respCode;

    private String respMsg;

    private String reqSerialNo;

    private String version;

    private R data;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
