/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.share;

import lombok.Data;

import java.io.Serializable;

/**
 * 分账授权结果查询
 *
 * @author linzy
 * @version AccreditQueryResponse.java, v 0.1 2021-05-06 11:50 linzy
 */
@Data
public class AccreditQueryResponse implements Serializable {

    private static final long serialVersionUID = 8597243206583630105L;

    /**
     * 0 未开通   1 已开通    2 商户主动关闭
     * <p>
     * 3 待审核    4 冻结      5 注销       6 待签合同
     */
    private Integer shareType;

    /**
     * 说明
     */
    private String shareTypeStr;

    /**
     * 合同h5地址 电子合同接口返回 只有已进行电子合同授权申请但未签署的商户会返回该链接。
     */
    private String contractUrl;
}
