/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.SubmchBindResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 高校分堂分店绑定参数
 *
 * @author buhao
 * @version SubmchBindRequest.java, v 0.1 2020-11-10 10:26 buhao
 */
@Data
public class SubmchBindRequest extends LeshuaBizRequest<SubmchBindResponse> {
    private static final long serialVersionUID = 7190196113599189812L;
    /**
     * 乐刷商户号
     */
    @NotBlank(message = "merchantId不能为空")
    @Length(max = 10, message = "merchantId超长")
    private String merchantId;
    /**
     * 需要绑定的子商户号
     */
    @NotBlank(message = "bindSubMchId不能为空")
    private String bindSubMchId;
    /**
     * 通过 pdf 上传接口返回的值
     */
    @NotBlank(message = "attachFile不能为空")
    private String attachFile;
    /**
     * 需要挂靠的分店商户号 ID
     */
    @NotEmpty(message = "不能为空")
    private List<String> shopMchIdList;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<SubmchBindResponse> getResponseClass() {
        return SubmchBindResponse.class;
    }
}