/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.client;

import com.fshows.leshuapay.sdk.enums.LeShuaSignTypeEnum;
import com.fshows.leshuapay.sdk.enums.LeshuaSettlementApiEnum;
import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.request.settlement.MerchantSettlementOrderRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import com.fshows.leshuapay.sdk.response.settlement.MerchantSettlementOrderBaseResponse;
import com.fshows.leshuapay.sdk.response.settlement.MerchantSettlementOrderResponse;

/**
 * 商户打款client
 *
 * @author zhaoyi
 * @version LeshuaPaymentClient.java, v 0.1 2020-07-30 16:57 zhaoyi
 */
public interface LeshuaPaymentClient {

    /**
     * 商户打款单结果查询
     *
     * @param request
     * @return
     */
    MerchantSettlementOrderResponse querySettlementOrder(MerchantSettlementOrderRequest request, LeshuaSettlementApiEnum apiEnum) throws LeshuaException;

    /**
     * 打款订单列表
     *
     * @param request
     * @param resClass
     * @param <Req>
     * @param <Res>
     * @return
     * @throws LeshuaException
     */
    <Req, Res> MerchantSettlementOrderBaseResponse<Res> execute(Req request, LeshuaSettlementApiEnum apiEnum, Class<Res> resClass) throws LeshuaException;

    /**
     * 提现等操作
     *
     * @param request 请求参数
     * @param apiEnum 网关
     * @param signTypeEnum 签名类型
     * @param <R>     返回类型
     * @return
     */
    <R> LeshuaBaseResponse<R> execute(LeshuaBizRequest<R> request, LeshuaSettlementApiEnum apiEnum, LeShuaSignTypeEnum signTypeEnum) throws LeshuaException;


}
