/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author youmingming
 * @version AccountSignTypeEnum.java, v 0.1 2021-04-01 11:46 上午 youmingming
 */
public enum LeShuaSignTypeEnum {
    TYPE_WITH_REQSERIALNO_VERSION_MD5("带版本号和序列号的MD5加签","MD5"),
    TYPE_WITHOUT_REQSERIALNO_VERSION_MD5("带版本号和序列号的MD5加签","MD5")
    ;

    private String name;
    private String value;

    LeShuaSignTypeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static LeShuaSignTypeEnum getByValue(String value) {
        LeShuaSignTypeEnum[] valueList = LeShuaSignTypeEnum.values();
        for (LeShuaSignTypeEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}