/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 商户信息修改request
 *
 * @author zhaoyi
 * @version MerchantSettleRequest.java, v 0.1 2020-07-27 11:50 zhaoyi
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantUpdateRequest extends LeshuaBizRequest<LeshuaBaseResponse> {

    @NotBlank(message = "merchantId不能为空")
    @Length(max = 10, message = "merchantId超长")
    private String merchantId;
    /**
     * 商户基本信息
     */
    private BaseInfo baseInfo;

    /**
     * 法人信息，个人类型填联系人信息
     */
    private LegalPerson legalPerson;

    /**
     * 联系人信息
     */
    private ContactInfo contactInfo;

    /**
     * 店铺地址信息
     */
    private AddressInfo addressInfo;

    /**
     * 营业资质信息
     * 小微进件不要传此对象
     */
    private LicenseInfo licenseInfo;

    /**
     * 结算信息
     */
    private AccountInfo accountInfo;

    /**
     * 门店信息
     */
    private ShopInfo shopInfo;

    /**
     * 微信信息
     */
    private WechatInfo wechatInfo;

    /**
     * 其它信息
     */
    private OtherInfo otherInfo;

    @Override
    public Class<LeshuaBaseResponse> getResponseClass() {
        return LeshuaBaseResponse.class;
    }
}
