/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 结算账户类型枚举
 *
 * @author zhaoyi
 * @version AccountTypeEnum.java, v 0.1 2020-08-03 10:56 zhaoyi
 */
public enum AccountTypeEnum {
    INDIVIDUAL_ACCOUNT(1, "个人账户"),
    COMPANY_ACCOUNT(2, "公司账户"),
    ;

    private Integer type;
    private String desc;

    AccountTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static AccountTypeEnum getByType(Integer type) {
        AccountTypeEnum[] valueList = AccountTypeEnum.values();
        for (AccountTypeEnum v : valueList) {
            if (v.getType().equals(type)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>type</tt>.
     *
     * @return property value of type
     */
    public Integer getType() {
        return type;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
