/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.settlement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.settlement.MerchantWithdrawBalanceQueryResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author youmingming
 * @version MerchantWithdrawBalanceQueryRequest.java, v 0.1 2021-04-01 1:57 下午 youmingming
 */
@Data
public class MerchantWithdrawBalanceQueryRequest extends LeshuaBizRequest<MerchantWithdrawBalanceQueryResponse> {

    /**
     * 乐刷商编
     */
    @NotBlank(message = "乐刷商编不能为空")
    private String merchantId;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantWithdrawBalanceQueryResponse> getResponseClass() {
        return MerchantWithdrawBalanceQueryResponse.class;
    }
}