/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.pay;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;

/**
 * 统一下单（主扫：C扫B）request
 *
 * @author zhaoyi
 * @version LeshuaBasePayRequest.java, v 0.1 2020-07-28 10:50 zhaoyi
 */
@Data
public class LeshuaQrAndJsPayRequest extends LeshuaBasePayRequest {

    private static final long serialVersionUID = -6806564122995030613L;

    /**
     * 接口名
     * 固定值
     */
    private String service = "get_tdcode";

    /**
     * 支付类型
     **/
    @NotBlank(message = "payWay不能为空")
    private String payWay;

    /**
     * 商户号
     * 由乐刷分配
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 商户订单号
     * 商户内部订单号，可以包含字母：确保同一个商户下唯一
     */
    @NotBlank(message = "thirdOrderId不能为空")
    private String thirdOrderId;

    /**
     * 订单金额，以分为单位
     * 总金额（金额不能为零或负数）
     **/
    @NotBlank(message = "amount不能为空")
    private String amount;

    /**
     * 支付宝smid和微信sub_mch_id
     **/
    private String assMerchantId;

    /**
     * 支付类型
     * 0-支付宝扫码支付、银联二维码扫码支付
     * 1-微信公众号、支付宝服务窗支付<原生支付>、银联js支付
     * 2-微信公众号、支付宝服务窗支付<简易支付>
     * 3-微信小程序支付、支付宝小程序支付
     **/
    @NotBlank(message = "jspayFlag不能为空")
    private String jspayFlag;

    /**
     * 公众号appid
     * 微信公众号ID ；微信公众号支付的公众号id。选填，如果传了会使用此appid 进行下单；没传使用商户进件时最新配置的 appid
     */
    private String appid;

    /**
     * 用户子标识
     * 微信公众号、小程序、支付宝服务窗、支付宝小程序、银联JS支付必填
     **/
    private String subOpenid;

    /**
     * 业务拓展参数
     * 当前可透传支付宝扫码点餐的参数，business_params、goods_detail、extend_params
     */
    private String extendBusinessParams;

    /**
     * 前台跳转地址
     * 简易支付时必填：支付完成后，乐刷将跳转到该页面，需做UrlEncode 处理
     */
    private String jumpUrl;

    /**
     * 通知地址
     * 接收乐刷通知（支付结果通知）的URL，需做UrlEncode 处理，需要绝对路径，确保乐刷能正确访问，若不需要回调请忽略
     **/
    private String notifyUrl;

    /**
     * 用户IP地址
     * 商户发起交易的IP地址
     **/
    private String clientIp;

    /**
     * 商品描述，不能包含回车换行等特殊字符
     */
    private String body;

    /**
     * T0标识，1：T0，不传或传0为T1
     **/
    private String t0;


    /**
     * 商户门店编号
     */
    private String shopNo;

    /**
     * 商户终端编号
     * 只能是汉字、英文字母、数字
     */
    private String posNo;

    /**
     * 附加数据
     * 下单成功原样返回；注意：只能是汉字、英文字母、数字
     */
    private String attach;

    /**
     * 指定支付方式
     * 1：禁止使用信用卡；0或者不填：不限制
     */
    private String limitPay;

    /**
     * 订单优惠标记，透传给微信
     */
    private String goodsTag;

    /**
     * 商品详情
     * 按微信单品优惠券格式传递透传给微信;请做UrlEncode
     */
    private String goodsDetail;

    /**
     * 订单有效时间
     * 单位：秒（支付宝的超时时间最小粒度为分钟，建议上送的为60的整数倍）
     */
    private String orderExpiration;

    /**
     * 支付宝花呗分期数，支持3、6、12期
     */
    private String hbFqNum;

    /**
     * 前端跳转地址
     * 银联JS支付时选填，支付成功时跳转
     */
    private String frontUrl;

    /**
     * 支付失败前端跳转地址
     * 银联JS支付时选填，支付失败时跳转
     */
    private String frontFailUrl;

    /**
     * 设备编号
     * 针对微信、支付宝有效，透传至银联。微信：数字、字母、下划线格式. 支付宝：目前支持非0开头的数字
     */
    private String deviceInfo;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
